﻿
Partial Class swapmanager
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site info class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    Protected Sub btnWishList_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnWishList.Click
        'save the indexes of both lists
        Call SaveIndexes()
        'redirect to the wish list manager
        Response.Redirect("wishlistmanager.aspx")
    End Sub

    Protected Sub btnLogout_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLogout.Click
        'clear the current user
        Session("TheCurrentUser") = Nothing
        'redirect to the main page
        Response.Redirect("default.aspx")
    End Sub

    Protected Sub btnDelete_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        'var for offer count
        Dim OfferCount As Integer
        'var to store the unique identifier of the swap
        Dim SwapNo As Integer
        'get the uinque identifier of the swap selected in the list
        SwapNo = lstSwaps.SelectedValue
        'get the number of offers on the swap
        OfferCount = GetOfferCount(SwapNo)
        'if there are no offers against this swap
        If OfferCount = 0 Then
            'store the swap number in the session variable
            Session("SwapNo") = SwapNo
            'save the indexes of both lists
            Call SaveIndexes()
            'redirect to the delete swap page
            Response.Redirect("deleteswap.aspx")
        Else
            lblError.Text = "You must clear all offers against this swap before you may delete it."
        End If
    End Sub

    Protected Sub btnAdd_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        'set the session variable to -1
        Session("SwapNo") = NO_ITEM
        'redirect to the add swap page
        Response.Redirect("aswap.aspx")
    End Sub

    Protected Sub btnEdit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnEdit.Click
        'var for offer count
        Dim OfferCount As Integer
        'var to store the unique identifier of the swap
        Dim SwapNo As Integer
        'get the uinque identifier of the swap selected in the list
        SwapNo = lstSwaps.SelectedValue
        'get the number of offers on the swap
        OfferCount = GetOfferCount(SwapNo)
        'if there are no offers against this swap
        If OfferCount = 0 Then
            'store the swap number in the session variable
            Session("SwapNo") = SwapNo
            'save the indexes of both lists
            Call SaveIndexes()
            'redirect to the edit swap page
            Response.Redirect("aswap.aspx")
        Else
            lblError.Text = "You cannot edit a swap while there are offers against it."
        End If
    End Sub

    Protected Sub btnDone_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnDone.Click
        'clear the indexes of the list boxes
        Call ClearIndexes()
        'go back to the main page
        Response.Redirect("default.aspx")
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        'check that a user is logged in
        Call CheckLogin()
        'if this is the first time the page has been displayed
        If IsPostBack = False Then
            'display the swaps
            Call DisplaySwaps()
            'set the list boxes to their old values if required
            Call SetLists()
        End If
    End Sub

    '#################
    'show offers code

    Sub CheckLogin()
        'this sub tests that the user has logged in correctly
        'if not then they are redirected to the main page
        'get the details of the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user object is not set up correctly
        If TheCurrentUser Is Nothing Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
        'if the current user is not authenticated
        If TheCurrentUser.Authenticated = False Then
            'go back to the main page
            Response.Redirect("Default.aspx")
        End If
    End Sub

    Sub DisplaySwaps()
        'this sub displays the swaps in the swaps list box
        '
        'open a connection to the database
        Dim MySwaps As New DatabaseTable("dvd.mdb", "select * from swap order by title", "#PN", "#PW")
        'var to store the count of swaps
        Dim SwapCount As Integer
        'var for the loop
        Dim Counter As Integer
        'var for the swap title
        Dim Title As String
        'var for the unique identifier of the swap
        Dim SwapNo As Integer
        'var to store the number of offers on a swap
        Dim OfferCount As Integer
        'get the number of swaps
        SwapCount = MySwaps.Count
        'loop through each swap
        For Counter = 0 To SwapCount - 1
            'get the swap number for this swap
            SwapNo = MySwaps.RecordNumber(Counter).Item("SwapNo")
            'get the title for this swap
            Title = MySwaps.RecordNumber(Counter).Item("Title")
            'get the number of offers on this swap
            OfferCount = GetOfferCount(SwapNo)
            'if there are no offers
            If OfferCount = 0 Then
                'then just add the title
                lstSwaps.Items.Add(Title)
            Else
                'else add the title with the number of offers
                lstSwaps.Items.Add(Title & " " & OfferCount & " offer(s)")
            End If
            'set the value property for this entry in the list box
            lstSwaps.Items.Item(Counter).Value = SwapNo
        Next
    End Sub

    Sub DisplayOffers(ByVal SwapNo As Integer)
        'this sub displays the offers for a swap specified by SwapNo
        '
        'open a connection to the database
        Dim Offers As New DatabaseTable("dvd.mdb", "select * from offer where SwapNo=" & SwapNo & " order by title", "#PN", "#PW")
        'var to stor the count of offers
        Dim OfferCount As Integer
        'var for the loop
        Dim Counter As Integer
        'var for the unique id of the offer
        Dim OfferNo As Integer
        'var for the title of the offer
        Dim Title As String
        'var for the acceptance date of the offer
        Dim AcceptanceDate As String
        'get the number of offers
        OfferCount = Offers.Count
        'clear the offers list box
        lstOffers.Items.Clear()
        'hide the accept offer button
        btnAccept.Visible = False
        'hide the reject offer button
        btnReject.Visible = False
        'display the edit swap button
        btnEdit.Visible = True
        'display the delete swap button
        btnDelete.Visible = True
        'clear the offer description label
        lblDescription.Text = ""
        'loop through each offer
        For Counter = 0 To OfferCount - 1
            'get the title of the offer
            Title = Offers.RecordNumber(Counter).Item("Title")
            'get the acceptance date of the offer
            Try
                'assume the field doesn't contain a null value
                AcceptanceDate = Offers.RecordNumber(Counter).Item("AcceptanceDate")
            Catch
                'if it is null then set AcceptanceDate to a blank string
                AcceptanceDate = ""
            End Try
            'get the unique identifier of the offer
            OfferNo = Offers.RecordNumber(Counter).Item("OfferNo")
            'add the offer to the list
            'if the acceptance date is blank
            If AcceptanceDate = "" Then
                'just add the title
                lstOffers.Items.Add(Title)
            Else
                'otherwise add the title and the acceptance date
                lstOffers.Items.Add(Title & " Offer accepted " & AcceptanceDate)
            End If

            'set the value property for this list entry
            lstOffers.Items.Item(Counter).Value = OfferNo
        Next
    End Sub

    Function GetOfferCount(ByVal SwapNo As Integer) As Integer
        'this function looks up records with this swap number
        'and returns the number of offers made on it
        '
        'open a connection to the database
        Dim Offers As New DatabaseTable("dvd.mdb", "select * from offer where SwapNo=" & SwapNo & " order by title", "#PN", "#PW")
        'var to store the count of offers
        Dim OfferCount As Integer
        'get the count of offers for this swap
        OfferCount = Offers.Count
        'return the offer count
        Return OfferCount
    End Function

    Protected Sub lstSwaps_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstSwaps.SelectedIndexChanged
        'this event runs when a swap is clicked on the list box
        'var to store the swap number
        Dim SwapNo As Integer
        'get the swap number from th list
        SwapNo = lstSwaps.SelectedValue
        'display the offers on this swap
        Call DisplayOffers(SwapNo)
    End Sub

    Function GetFullDetails(ByVal OfferNo As Integer) As String
        'this function returns the full details as an html formatted string of the offer and the person making the offer
        'it accepts one parameter which is the offer number
        '
        'open a connection to the database
        Dim Offers As New DatabaseTable("dvd.mdb", "select * from offer where OfferNo=" & OfferNo, "#PN", "#PW")
        'var to store the title of the offer
        Dim OfferTitle As String
        'var to store the description of the offer
        Dim OfferDescription As String
        'var to store the unique identifier of the person making the offer
        Dim UserNo As Integer
        'var to store the first name of the person making the offer
        Dim FirstName As String
        'var to store the last name of the person making the offer
        Dim LastName As String
        'var to store the email of the person making the offer
        Dim EMail As String
        'var to store the full details of the offer and the person making it
        Dim FullDetails As String
        'make the accept offer button visible
        btnAccept.Visible = True
        'make the reject offer button visible
        btnReject.Visible = True
        'if the offer is found
        If Offers.Count = 1 Then
            'get the user no for the person making the offer
            UserNo = Offers.RecordNumber(0).Item("UserNo")
            'get the title of the offer
            OfferTitle = Offers.RecordNumber(0).Item("Title")
            'get the description of the offer
            OfferDescription = Offers.RecordNumber(0).Item("Description")
            'open a connection to the database to find the details of the person making the offer
            Dim Users As New DatabaseTable("dvd.mdb", "select * from Users where UserNo=" & UserNo, "#PN", "#PW")
            'if the person is found
            If Users.Count = 1 Then
                'get their first name
                FirstName = Users.RecordNumber(0).Item("FirstName")
                'get their last name
                LastName = Users.RecordNumber(0).Item("LastName")
                'get their email
                EMail = Users.RecordNumber(0).Item("EMail")
                'concatenate the values to produce the formatted string
                FullDetails = "<b>Offer Details</b><br>" & FirstName & " " & LastName & "<br>" & EMail & "<br>" & OfferTitle & "<br>" & OfferDescription
                'return the formatted string
                Return FullDetails
            Else
                'return a blank string
                Return ""
            End If
        Else
            'return a blank string
            Return ""
        End If
    End Function

    Protected Sub lstOffers_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstOffers.SelectedIndexChanged
        'this event runs when the user clicks on the offers list box
        'var to store the offer no
        Dim OfferNo As Integer
        'get the offer no
        OfferNo = lstOffers.SelectedValue
        'get the full details of the offer and display in lblDescription
        lblDescription.Text = GetFullDetails(OfferNo)
    End Sub


    '####################
    'accept offer code

    Protected Sub btnAccept_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnAccept.Click
        'this event runs when a swap is accepted by pressing the accept swap 
        '
        'var to store the unique identifier of the selected swap
        Dim SwapNo As Integer
        'ver to store the uniqui identifier of the selected offer
        Dim OfferNo As Integer
        'get the swap number
        SwapNo = lstSwaps.SelectedValue
        'get the offer number
        OfferNo = lstOffers.SelectedValue
        'accept the offer for this swap
        Call AcceptOffer(SwapNo, OfferNo)
        'update the list of offers
        Call DisplayOffers(SwapNo)
    End Sub

    Private Sub AcceptOffer(ByVal SwapNo As Integer, ByVal OfferNo As Integer)
        'this sub accepst an offer made on a swap
        'it accepts two parameters the swap number and the offer number
        'it sends an email to the person making the offer
        'and another email to the site owner
        'the offer is date stamped so that the site owner knows when the offer was accepted
        '
        'my email object used to send emails
        Dim AnEmail As New MyEMail
        'var to store the email address of the person making the offer
        Dim OfferEMail As String
        'var to store the title of the offered item
        Dim OfferTitle As String
        'var to store the title of the swap
        Dim SwapTitle As String
        'var to store the name of the person making the offer
        Dim OfferUserName As String
        'get the email address of the person making the offer
        OfferEMail = GetOfferEMail(OfferNo)
        'get the title of the item being swapped
        SwapTitle = GetSwapTitle(SwapNo)
        'get the title of the item being offered
        OfferTitle = GetOfferTitle(OfferNo)
        'get the name of the person making the offer
        OfferUserName = GetOfferUserName(OfferNo)
        'construct and send an acceptance email to the person making the offer
        AnEmail.SendEMail(ThisSite.OwnerEMail, OfferEMail, "Your offer has been accepted", ThisSite.SiteOwner & " has accepted your offer of " & OfferTitle & " for " & SwapTitle & " please reply to this email to arrange the exchange.")
        'construct and send an email to the owner of the site
        AnEmail.SendEMail(OfferEMail, ThisSite.OwnerEMail, "You have accepted my offer", OfferUserName & " is going to swap " & OfferTitle & " for " & SwapTitle & " reply to this message to arrange an exchange.")
        'date stamp the swap
        'open a connection to the database finding the record for this offer
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from Offer where OfferNo = " & OfferNo, "#PN", "#PW")
        'date stamp the offer
        AnOffer.RecordNumber(0).Item("AcceptanceDate") = Now.Day & "/" & Now.Month & "/" & Now.Year
        'save the changes
        AnOffer.SaveChanges()
    End Sub

    Function GetOfferEMail(ByVal OfferNo As Integer) As String
        'this function looks up the offer no in the offer table to find the user who made the offer
        'it then looks up that person's user no in the users table to find their email address
        'it returns their email address
        '
        'var to store the user no of the person who made the offer
        Dim UserNo As Integer
        'var to store the email address of the person who made the offer
        Dim EMail As String
        'open the database to find the record for this offer
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the record is found
        If AnOffer.Count = 1 Then
            'get the user no of the person making the offer
            UserNo = AnOffer.RecordNumber(0).Item("UserNo")
            'get the record for this user
            Dim AUser As New DatabaseTable("dvd.mdb", "select * from users where userno=" & UserNo, "#PN", "#PW")
            'if the user is found
            If AUser.Count = 1 Then
                'get their email address
                EMail = AUser.RecordNumber(0).Item("EMail")
                'return the email address
                Return EMail
            Else
                'return a blank string
                Return ""
            End If
        Else
            'return a blank string
            Return ""
        End If
    End Function

    Function GetOfferUserName(ByVal OfferNo As Integer) As String
        'this function returns the full name of the person making an offer
        'it acceptes one parameter which is the offer number
        'it first looks up the offer in the offer table to find the user no of the person making the offer
        'it next looks in the users table to find the name of the person
        '
        'var to store the user number of the person making the offer
        Dim UserNo As Integer
        'var to store the full name of the person making the offer
        Dim FullName As String
        'open the database locating the record for this offer
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the offer is found
        If AnOffer.Count = 1 Then
            'get the id of the user making the offer
            UserNo = AnOffer.RecordNumber(0).Item("UserNo")
            'open the database locating the user record for this person
            Dim AUser As New DatabaseTable("dvd.mdb", "select * from users where userno=" & UserNo, "#PN", "#PW")
            'if the record is found
            If AUser.Count = 1 Then
                'get the full name of the person making the offer
                FullName = AUser.RecordNumber(0).Item("FirstName") & " " & AUser.RecordNumber(0).Item("LastName")
                'retuurn the full name
                Return FullName
            Else
                'return a blank string
                Return ""
            End If
        Else
            'return a blank string
            Return ""
        End If
    End Function

    Function GetOfferTitle(ByVal OfferNo As Integer) As String
        'this function looks up the title for an offer based on the offer no
        '
        'var to store the title of the offer
        Dim Title As String
        'look up the offer in the database
        Dim AnOffer As New DatabaseTable("dvd.mdb", "select * from offer where offerno=" & OfferNo, "#PN", "#PW")
        'if the record is found
        If AnOffer.Count = 1 Then
            'get the title
            Title = AnOffer.RecordNumber(0).Item("Title")
            'return the title
            Return Title
        Else
            'return the title
            Return ""
        End If
    End Function

    Function GetSwapTitle(ByVal SwapNo As Integer) As String
        'this function looks up and returns the title of a swap based on the swap number
        '
        'var to store the title of the swap
        Dim Title As String
        'look up the swap in the database
        Dim AnSwap As New DatabaseTable("dvd.mdb", "select * from swap where swapno=" & SwapNo, "#PN", "#PW")
        'if the record is found
        If AnSwap.Count = 1 Then
            'get the title of the swap
            Title = AnSwap.RecordNumber(0).Item("Title")
            'return the title
            Return Title
        Else
            'return a blank string
            Return ""
        End If
    End Function


    '###############
    'reject offer code

    Protected Sub btnReject_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnReject.Click
        'this event is triggered when the user presses the reject offer button
        Dim OfferNo As Integer
        'get the unique identifier of the offer to be rejected
        OfferNo = lstOffers.SelectedValue
        'store the offer no to be removed in the session object
        Session("OfferNo") = OfferNo
        'save the indexes of both lists
        Call SaveIndexes()
        'display the reject offer page
        Response.Redirect("rejectoffer.aspx")
    End Sub

    Sub SetLists()
        'this sub attempts to set the list indexes of the two list 
        'boxes back to the value they had when the page was last used
        '
        'var to store the swap index 
        Dim SwapIndex As String
        'var to store the offer index
        Dim OfferIndex As String
        'var to store the swap no
        Dim SwapNo As Integer
        'var to store the offer no
        Dim OfferNo As Integer
        'get the index of the swap from the session object
        SwapIndex = Session("SwapIndex")
        'get the index of the offer from the session object
        OfferIndex = Session("OfferIndex")
        'if the swap index is a number and not -1
        If IsNumeric(SwapIndex) = True And SwapIndex <> NO_ITEM Then
            'set the index of the list box
            lstSwaps.SelectedIndex = SwapIndex
            'get the unique identifier of the selected swap
            SwapNo = lstSwaps.SelectedValue
            'if the index of the list is set
            If lstSwaps.SelectedIndex <> NO_ITEM Then
                'display the edit button
                btnEdit.Visible = True
                'display the delete button
                btnDelete.Visible = True
            End If
        End If
        'if the offer index is a number and not = -1
        If IsNumeric(OfferIndex) = True And OfferIndex <> NO_ITEM Then
            'display the offers for the selected swap
            Call DisplayOffers(SwapNo)
            'set the index of the offer list box
            lstOffers.SelectedIndex = OfferIndex
            Try
                'try to set the index
                OfferNo = lstOffers.SelectedValue
                'get the details of the selected offer
                lblDescription.Text = GetFullDetails(OfferNo)
            Catch
                'do nothing
            End Try
        End If
    End Sub

    Sub SaveIndexes()
        'this sub saves the indexes for both lists into the session object
        Session("SwapIndex") = lstSwaps.SelectedIndex
        Session("OfferIndex") = lstOffers.SelectedIndex
    End Sub

    Sub ClearIndexes()
        'this sub clears the indexes stored in the session object
        Session("SwapIndex") = -1
        Session("OfferIndex") = -1
    End Sub
End Class
